#!/usr/bin/perl -w

use English;
use File::Basename;

my @papers = ( `cat paperlist.txt` );
chomp @papers;
my $vol = "AJ";
my $num = "01";
my $volume = "dm${vol}${num}";
my $year = "2008";

my $pap = 1;

$ENV{PATH} = "/bin:/usr/bin:/usr/lib";

do "html-TeX.pl";

sub filesize {
  my $name = shift;
  my @ret = stat($name);
  my $ret = $ret[7];
  $ret = 0 if (!defined($ret));
  $ret = int($ret/1024);
  #print STDERR `pwd` . "/${name} ... ${ret} ... @ret\n";
  return $ret;
}

sub textranschar{
    local($arg)=@_;
    return "&nbsp;" if ($arg eq "~");
    return "&nbsp;" if ($arg eq " ");
    return "" if ($arg eq "
");
    return "<br/><math>" if ($arg eq "[");
    return "</math><br/>" if ($arg eq "]");
    #return "&cr;" if ($arg eq "\\");
    return " " if ($arg eq "\\");
    return "&#10;" if ($arg eq "\n");
    return "&tab;" if ($arg eq "&");
    return "&lt;" if ($arg eq "<");
    return "&gt;" if ($arg eq ">");
    return "&quot;" if ($arg eq qq {"} );
    return sprintf("&#x%x;",ord($arg));
}

my %texcom = (
	      "par" => "<br />",
	      "relax" => " ",
# 	      "log" => "<i>log</i>",
# 	      "ln" => "<i>ln</i>",
# 	      "cos" => "<i>cos</i>",
# 	      "sin" => "<i>sin</i>",
	      "nobreakspace" => "&nbsp;",
	      "quad" => "&nbsp;",
	      "left" => "",
	      "right" => "",
	      "noindent" => "",
	      "in" => "&isin;",
	      "textbf" => "&b;",
	      "textit" => "&i;",
	      "textrm" => "&textrm;",
	      "bf" => "&b;",
	      "it" => "&i;",
	      "emph" => "&em;",
	      "to" => "&rarr;",
	      "gets" => "&larr;",
              "hfil" => " ",
              "hfill" => " ",
              "ensuremath" => "",
              "log" => '<span>log</span>',
 	     );

my %TeX_html_table = ();

sub textranscom {
  local($arg)=@_;
  #print STDERR "searching for `${arg}', ".$TeX_html_table{"{${arg}}"}."\n";
  return $TeX_html_table{$arg} if (defined($TeX_html_table{$arg}));
  return $TeX_html_table{"\\$arg"} if (defined($TeX_html_table{"\\$arg"}));
  return $TeX_html_table{"\{\\$arg\}"} if (defined($TeX_html_table{"\{\\$arg\}"}));
  return $texcom{$arg} if (defined($texcom{$arg}));
  return "&${arg};";
}

sub textrans{
    local($arg)=$_[0];
    local($ret) = $arg;
    $ret =~ s/([\t<>&~
])/&textranschar($1)/ge;
    $ret =~ s/[\\][,;:]/ /go;
    $ret =~ s/[\\][\\]\[[^\[\]]+\]/ /go;
    $ret =~ s/[\\]([\\{}\[\] ])/&textranschar($1)/ge;
    $ret =~ s/[\\](['`^"=~.])[\\]([ij]) {1,}/&textranscom("\\$1\{\\$2\}")/ge;
    $ret =~ s/[\\](['`^"=~.])([^{}\\ ])/\\$1\{$2\}/go;
    $ret =~ s/[\\](['`^"=~.])[{]([^{}]{1,})[}]/&textranscom("\{\\$1$2\}")/ge;
    $ret =~ s/[\\]([uvcCHU]) {1,}([^{\\])/&textranscom("\\$1\{$2\}")/ge;
    $ret =~ s/[\\]([uvcCHU])[{]([^{}\\]{1,})[}]/&textranscom("\\$1\{$2\}")/ge;
    $ret =~ s/[\\]([uvcCHU]) {0,}[{]([^{}\\]{1,})[}]/&textranscom("\\$1\{$2\}")/ge;
    $ret =~ s|[\\]frac{([^{}]+)}{([^{}]+)}|$1&#8202;/&#8202;$2|go;
    $ret =~ s|[\\]setminus|&nbsp;\\&nbsp;|go;
    $ret =~ s|[{][\\]mathbb[ ]{1,}([a-zA-Z])[}]|&mathbb($1)|ge;
    $ret =~ s/[{][\\]([a-zA-Z]{1,})[ \t]*[}]/&textranscom($1)/ge;
    $ret =~ s/[\\]([a-zA-Z]{1,})[ ]*/&textranscom($1)/ge;
    #$ret =~ s/[\\]([a-zA-Z]{1,})([ \t\n]{1,})/&textranscom($1).$2/ge;
    $ret =~ s|[\^]([&][^;]{1,}[;])|<sup>$1</sup>|go;
    $ret =~ s|[\^]([^{])|<sup>$1</sup>|go;
    $ret =~ s|[\^][{]([^{}]{1,})[}]|<sup>$1</sup>|go;
    $ret =~ s|[_]([&][^;]{1,}[;])|<sub>$1</sub>|go;
    $ret =~ s|[_]([^{])|<sub>$1</sub>|go;
    $ret =~ s|[_][{]([^{}]{1,})[}]|<sub>$1</sub>|go;
    $ret =~ s|[ \t]{1,}| |goim;
    $ret =~ s|[&]nbsp;[ \t]*|&nbsp;|goim;
    $ret =~ s|[&]nbsp;$||goim;
    $ret =~ s|\${1,}([^\$]*)\${1,}|<math>$1</math>|go;
    return $ret;
}



foreach my $code (sort(keys(%html_TeX_table))) {
  $TeX_html_table{$html_TeX_table{$code}} = "&${code};";
}



mkdir "plain";

foreach my $paper (@papers) {
  my $name = sprintf("%s%02d", $volume, $pap);
  my %keys = ();
  $keys{PAPER} = $pap;
  print STDERR "Processing ${paper} -> ${name}\n";


  open(HEADER,"<${paper}/header.tex");
 readloop:
  foreach my $line (<HEADER>) {
    chomp $line;
    next readloop if ($line =~ m/^[ 	]*$/);
    my ($key,$value) = $line =~ m/([A-Za-z]*){(.*)}/;
    $key = "\U${key}\E";
    $keys{$key} = textrans($value);
    $keys{$key} =~ s|[{]([^{}]{1,})[}]|<div class="group">$1</div>|goim;
  }
  close(HEADER);
  open(TEX,"<${paper}/${paper}.tex");
  my $state = 0;
  my @cumul = ();
  foreach $line (<TEX>) {
    my ($real,@comment) = split(/%/, $line);
    while (@comment && substr($real, -1, 1) =~ /[\\]/) {
      $real = substr($real, 0, length($real) - 1);
      $real .= "%";
      $real .= shift @comment;
    }
    $line = $real;
    $line = textrans($line);
    if ($state == 0) {
      my ($rem) = qq($line) =~ m/begin; *{abstract}(.*)/;
      if (defined($rem)) {
	print STDERR "found beginning of abstract\n";
	$state = 1;
	push @cumul, qq($rem);
      }
    } elsif ($state == 1) {
      my ($rem) = $line =~ m/(.*).end; *{abstract}/;
      if (defined($rem)) {
	print STDERR "found end of abstract\n";
	$state = 2;
	push @cumul, qq($rem);
	last;
      } else {
	push @cumul, qq($line);
      }
    }
  }
  close(TEX);
  chomp @cumul;
  my $abs = join(" ", qq(@cumul));
  $abs =~ s![ \t]{1,}! !goim;
  $abs =~ s![{][}]! !goim;
  $abs =~ s![{][&]([a-z]{1,});[}]!&$1;!goim;
  $abs =~ s![{][&]([a-z]{1,});[ \t]*([^{}]*)[}]!<$1>$2</$1>!goim;
  $abs =~ s![&](cite);[ \t]*[{]([^{}]*)[}]![$2]!goim;
  $abs =~ s![&](binom);[ \t]*[{]([^{}]*)[}][ \t]*[{]([^{}]*)[}]!<binom>$2, $3</binom>!goim;
  $abs =~ s![&](textrm);[ \t]*[{]([^{}]*)[}]!<mathop>$2</mathop>!goim;
  $abs =~ s![&](textsc);[ \t]*[{]([^{}]*)[}]!<textsc>$2</textsc>!goim;
  $abs =~ s![&]([a-z]{1,});[ \t]*[{][ \t]*([^{}]*)[}]!<$1>$2</$1>!goim;
  $abs =~ s![{]([^{}]*)[}]!<div class="group">$1</div>!goim;
  $abs =~ s![<]begin[^>]*[>]([a-z]{1,})[<]/begin[>]!<$1>!go;
  $abs =~ s![<]end[^>]*[>]([a-z]{1,})[<]/end[>]!</$1>!go;
  $abs =~ s!\${1,}([^\$]*)\${1,}!<math>$1</math>!go;

  $abs =~ s!<paragraph>Abstract.?</paragraph>!!go;
  $abs =~ s!<paragraph>(.+)</paragraph>!<br />\n<h5>$1</h5>!go;

  @cumul = split("([ ].{50,70}[ ])", $abs);
  $keys{ABSTRACT} = join("\n  ", @cumul);
  foreach my $key (keys(%keys)) {
    $keys{$key} =~ s/{\\ }/ /g;
    #print STDERR qq($key), ": ", qq($keys{$key}), "\n";
  }
  open(PLAIN,">plain/$name.abs");
  print PLAIN "VOLUME: ${vol}\n\n";
  print PLAIN "NUMBER: ${num}\n\n";
  print PLAIN "PAPER: $keys{PAPER}\n\n";
  print PLAIN "YEAR: ${year}\n\n";
  print PLAIN "PAGES: $keys{PAGESTART}-$keys{PAGEEND}\n\n";
  print PLAIN "PDF-SIZE: ".filesize("pdfpapers/$name.pdf")." K\n\n";
  print PLAIN "PS-SIZE: ".filesize("pspapers/$name.ps")." K\n\n";
  print PLAIN "PS.GZ-SIZE: ".filesize("ps.gzpapers/$name.ps.gz")." K\n\n";
  print PLAIN "AUTHOR: ".join(" and ", author_list($keys{AUTHORHEAD}))."\n\n";
  print PLAIN "TITLE: $keys{TITLELONG}\n\n";
  print PLAIN "KEYWORDS: $keys{KEYWORDS}\n\n";
  print PLAIN "ABSTRACT: $keys{ABSTRACT}\n\n";
  close(PLAIN);
  ++$pap;
}

