#!/usr/bin/perl -w -s
#  We don't know what you expect, but it is really -*- perl -*-
#  Copyright (C) 2005, 2008 DMTCS, Nancy, France
#  Author: Jens Gustedt <Jens Gustedt [AT] dmtcs org>

## This script does two tasks. One for an individual target paper
## is `linking' to the directory that is preceeds in the volume.
if (defined($target)) {
  print STDOUT "Target is $target\n";
  my $dumptext = "\\gdef\\previous{}";
  foreach $dir (<>) {
    chomp $dir;
    my $file = "$dir/previous.tex";
    if ( "$dir" =~ "$target" ) {
      print STDOUT "Generating $file\n";
      open(OUT, ">$file");
      print OUT "$dumptext\n";
      close(OUT);
    }
    $dumptext = "\\gdef\\previous{$dir}";
  }
} else {
## The others, more general, are to generate a Makefile for the
## dependencies and a file that will help latex to generate a
## table of contents.
##
## As a first task we have to find the volume ID.
  open(INFO,"<volume-info.tex");
  my $vid;
  while (<INFO>) {
    chomp;
    ($id) = m/.*publicationid{(..)}.*/g;
    $vid = $id if (defined($id));
  }
  close(INFO);
##
  if (defined($vid)) {
    print STDOUT "Volume id is $vid.\n";
    my $id = 100;
    open(TOC,">gentoc.tex");
    open(MAK,">Makefile-inc");
    my @tpdf = ();
    my @tps = ();
    my @tpsgz = ();
    my $vname = sprintf("dm%2s", ${vid});
    my $previous = "./header.tex";
    foreach $dir (<>) {
      chomp $dir;
      print TOC "\\headerinput{$dir}\n";
      ++$id;
      my $tname = sprintf("%4s%04d", ${vname}, ${id});
      print STDOUT "generating dependencies for target ${tname} (${dir})\n";
      my $here = "$dir/header.tex";
      print MAK "## $here is generated by latex\n$here : $dir/$dir.tex\n\n";
      print MAK "$dir/$dir.ps : \${META} $previous $dir/previous.tex $dir/dmtcs.cls\n\n";
      print MAK "$dir/$dir.pdf : \${META} $previous $dir/previous.tex $dir/dmtcs.cls\n\n";
      unshift(@tpdf,"pdfpapers/${tname}.pdf");
      print MAK "$tpdf[0] : $dir/$dir.pdf\n\t\${CP} $dir/$dir.pdf $tpdf[0]\n\n";
      unshift(@tps,"pspapers/${tname}.ps");
      print MAK "$tps[0] : $dir/$dir.ps\n\t\${CP} $dir/$dir.ps $tps[0]\n\n";
      unshift(@tpsgz,"ps.gzpapers/${tname}.ps.gz");
      print MAK "$tpsgz[0] : $tps[0]\n\n";
      $previous = $here;
    }

    close(TOC);

    print MAK "PDF =\t".join("\\\n\t", reverse(@tpdf))."\n\n";
    print MAK "PS =\t".join("\\\n\t", reverse(@tps))."\n\n";
    print MAK "PSGZ =\t".join("\\\n\t", reverse(@tpsgz))."\n\n";

    print MAK "pdf : \${PDF}\n\n";
    print MAK "ps : \${PS}\n\n";
    print MAK "psgz : \${PSGZ}\n\n";

#     print MAK ".LOW_RESOLUTION_TIME : \${PDF}\n\n";
#     print MAK ".LOW_RESOLUTION_TIME : \${PS}\n\n";
#     print MAK ".LOW_RESOLUTION_TIME : \${PSGZ}\n\n";

    print MAK "${vname}.tgz :  \${ALLDIRS} \${PSGZ} \${PS} \${PDF} .touch\n\n";
    print MAK ".touch :\n\t\${TOUCH} \${PSGZ} \${PS} \${PDF}\n\n";
    print MAK "tgz : ${vname}.tgz\n\n";
    print MAK "tgzclean :\n\t\${RM} ${vname}.tgz\n\n";

    close(MAK);
  } else {
    die "did not find publication id in volume-info.tex" ;
  }
}
