#! /usr/local/bin/perl5 -w
#  We don't know what you expect, but it is really -*- perl -*-

use English;


  %html_TeX_table = (
   'quot'	=> '\\"{\\ }',
   'amp'	=> qw(\&),
   'lt'		=> qw(<),
   'gt'		=> qw(>),
   'nbsp'	=> "\\ ",	# {~}: NBSP no-break space:
   'iexcl'	=> qw(\!`}),	# {!`}: inverted exclamation mark
   'cent'	=> qw({c/}),	# {c}: cent sign
   'pound'	=> qw({\pounds}),      # {\pounds}: pound sign
   'curren'	=> qw({$}),	# {$}: general currency sign
   'yen'	=> qw({JPY}),	# {JPY}: yen sign
   'brvbar'	=> qw({|}),	# {|}: broken vertical line
   'sect'	=> qw({\S}),	# {\S}: section sign
   'uml'	=> '\\"{\\ }',	# \"\ : diaeresis
   'copy'	=> qw({\copyright}),	# {\copyright}: copyright sign
   'ordf'	=> qw({_a}),	# {_a}: ordinal indicator, feminine
   'laqo'	=> qw({\guillemotleft}),	# {\guillemotleft}: left angle quotation m
   'not'	=> qw({\neg}),	# {\neg}: not sign
   'shy'	=> qw(-),	# \"-: soft hyphen
   'reg'	=> qw({\(R\)}),	# {(R)}: registered sign
   'macr'	=> qw({=}),	# {=}: macron
   'deg'	=> qw(^{\circ}),	# ^{\circ}: superscript zero or degree si
   'plusmn'	=> qw({\pm}),	# {\pm}: plus or minus sign
   'sup2'	=> qw(^{2}),	# ^{2}: superscript two
   'sup3'	=> qw(^{3}),	# ^{3}: superscript three
   'acute'	=> "\\'{\\ }",	# \'\ : acute accent
   'micro'	=> qw({\mu}),	# {\mu}: micro sign
   'para'	=> qw({\P}),	# {\P}: pilcrow
   'middot'	=> qw({\cdot}),	# {\cdot}: middle dot
   'cedil'	=> "\\c{\\ }",	# \c{\ }: cedilla
   'supl'	=> qw(^{1}),	# ^{1}: superscript one
   'ordm'	=> qw(^{o}),	# ^{o}: ordinal indicator, masculine
   'raquo'	=> qw({\guillemotright}),	# {\guillemotright}: right angle quotati
   'fraq14'	=> qw({1/4}),	# {1/4}: fraction one-quarter
   'fraq12'	=> qw({1/2}),	# {1/2}: fraction one-half
   'fraq34'	=> qw({3/4}),	# {3/4}: fraction three-quarters
   'iquest'	=> qw({?`}),	# {?`}: inverted question mark
   'Agrave'	=> qw({\`A}),	# \`A: A with grave accent
   'Aacute'	=> qw({\'A}),	# \'A: A with acute accent
   'Acirc'	=> qw({\^A}),	# \^A: A with circumflex accent
   'Atilde'	=> qw({\~A}),	# \~A: A with tilde
   'Auml'	=> qw({\"A}),	# \"A: A with diaeresis or umlaut mark
   'Aring'	=> qw({\AA}),	# {\AA}: A with ring
   'AElig'	=> qw({\AE}),	# {\AE}: AE diphthong
   'Ccedil'	=> qw(\c{C}),	# \c{C}: C with cedilla
   'Egrave'	=> qw({\`E}),	# \`E: E with grave accent
   'Eacute'	=> qw({\'E}),	# \'E: E with acute accent
   'Ecirc'	=> qw({\^E}),	# \^E: E with circumflex accent
   'Euml'	=> qw({\"E}),	# \"E: E with diaeresis or umlaut mark
   'Igrave'	=> qw({\`I}),	# \`I: I with grave accent
   'Iacute'	=> qw({\'I}),	# \'I: I with acute accent
   'Icirc'	=> qw({\^I}),	# \^I: I with circumflex accent
   'Iuml'	=> qw({\"I}),	# \"I: I with diaeresis or umlaut mark
   'ETH'	=> qw({-D}),	# {-D}: D with stroke, Icelandic eth
   'Ntilde'	=> qw({\~N}),	# \~N: N with tilde
   'Ograve'	=> qw({\`O}),	# \`O: O with grave accent
   'Oacute'	=> qw({\'O}),	# \'O: O with acute accent
   'Ocirc'	=> qw({\^O}),	# \^O: O with circumflex accent
   'Otilde'	=> qw({\~O}),	# \~O: O with tilde
   'Ouml'	=> qw({\"O}),	# \"O: O with diaeresis or umlaut mark
   'times'	=> qw({\times}),	# {\times}: multiplication sign
   'Oslash'	=> qw({\O}),	# {\O}: O with slash
   'Ugrave'	=> qw({\`U}),	# \`U: U with grave accent
   'Uacute'	=> qw({\'U}),	# \'U: U with acute accent
   'Ucirc'	=> qw({\^U}),	# \^U: U with circumflex accent
   'Uuml'	=> qw({\"U}),	# \"U: U with diaeresis or umlaut mark
   'Yacute'	=> qw({\'Y}),	# \'Y: Y with acute accent
   'THORN'	=> qw({\TH}),	# {\TH}: capital thorn, Icelandic
   'szlig'	=> qw({\ss}),	# {\ss}: small sharp s, German
   'agrave'	=> qw({\`a}),	# \`a: a with grave accent
   'aacute'	=> qw({\'a}),	# \'a: a with acute accent
   'acirc'	=> qw({\^a}),	# \^a: a with circumflex accent
   'atilde'	=> qw({\~a}),	# \~a: a with tilde
   'auml'	=> qw({\"a}),	# \"a: a with diaeresis or umlaut mark
   'aring'	=> qw({\aa}),	# {\aa}: a with ring
   'aelig'	=> qw({\ae}),	# {\ae}: ae diphthong
   'ccedil'	=> qw(\c{c}),	# \c{c}: c with cedilla
   'egrave'	=> qw({\`e}),	# \`e: e with grave accent
   'eacute'	=> qw({\'e}),	# \'e: e with acute accent
   'ecirc'	=> qw({\^e}),	# \^e: e with circumflex accent
   'euml'	=> qw({\"e}),	# \"e: e with diaeresis or umlaut mark
   'igrave'	=> qw(\`{\i}),# \`{\i}: i with grave accent
   'iacute'	=> qw(\'{\i}),# \'{\i}: i with acute accent
   'icirc'	=> qw(\^{\i}),# \^{\i}: i with circumflex accent
   'iuml'	=> qw(\"{\i}),# \"{\i}: i with diaeresis or umlaut mark
   'eth'	=> qw({\-d}),	# {-d}: d with stroke, Icelandic eth
   'ntilde'	=> qw({\~n}),	# \~n: n with tilde
   'ograve'	=> qw({\`o}),	# \`o: o with grave accent
   'oacute'	=> qw({\'o}),	# \'o: o with acute accent
   'ocirc'	=> qw({\^o}),	# \^o: o with circumflex accent
   'otilde'	=> qw({\~o}),	# \~o: o with tilde
   'ouml'	=> qw({\"o}),	# \"o: o with diaeresis or umlaut mark
   'divide'	=> qw({\div}),	# {\div}: division sign
   'oslash'	=> qw({\o}),	# {\o}: o with slash
   'ugrave'	=> qw({\`u}),	# \`u: u with grave accent
   'uacute'	=> qw({\'u}),	# \'u: u with acute accent
   'ucirc'	=> qw({\^u}),	# \^u: u with circumflex accent
   'uuml'	=> qw({\"u}),	# \"u: u with diaeresis or umlaut mark
   'yacute'	=> qw({\'y}),	# \'y: y with acute accent
   'thorn'	=> qw({\th}),	# {\th}: small thorn, Icelandic
   'yuml'	=> qw({\"y}),	# \"y: y with diaeresis or umlaut mark
# some specialities
		      'isin' => qw({\in}), # is element of
		      '#8712' => qw({\in}), # is element of
		      'sub' => qw({\subset}), # is subset of 
		      'sube' => qw({\subseteq}), # is subset (or equal) of 
		      'sup' => qw({\supset}), # is superset of 
		      'supe' => qw({\supseteq}), # is superset (or equal) of 
		      'hellip' => qw({\ldots}),
          'rarr' => qw({\rightarrow}), # rightarrow
          'larr' => qw({\leftarrow}), # leftarrow
          'rArr' => qw({\Rightarrow}), # rightarrow
          'lArr' => qw({\Leftarrow}), # leftarrow
          'infin' => qw({\infty}),
	  '#931' => qw(\sum ),
	  '#x227A' => qw({\prec}),
	  '#x22C2' => qw(\bigcap ),
	  '#x22C3' => qw(\bigcup ),
	  '#x03C6' => qw({\varphi}),
		     '#8776' => qw(\approx ),
		     '#8771' => qw(\simeq ),
		     '#x7b' => qw(\{),
		     '#x7d' => qw(\}),
	  'weierp' => qw({\wp}),
		     "#603" => qw{{\varepsilon}},
		     "#321" => qw{{\L}},
		     "#322" => qw{{\l}},
		     "#x2260" => qw{{\neq}},
		     "#x2264" => qw{{\leq}},
		     "#x2265" => qw{{\geq}},
		     "#8202" => '\,',
		     "#8484" => qw{{\integers}},
		     "#8469" => qw{{\naturals}},
		     "#8450" => qw{{\complexes}},
		     "#8469" => qw{{\naturals}},
		     "#8473" => qw{{\primes}},
		     "#8474" => qw{{\rationals}},
		     "#8477" => qw{{\reals}},
		     '#8943' => qw({\cdots}),
		     "#x2113" => qw{{\ell}},
		     "#x2205" => qw{{\emptyset}},
		     "#x2551" => qw{{\parallel}},
# the character codes
   '#146'	=> qw('),
   '#150'	=> qw(-),
#   '#160'	=> qw({~}),	# {~}: NBSP no-break space:
   '#161'	=> qw({!`}),	# {!`}: inverted exclamation mark
   '#162'	=> qw({c/}),	# {c}: cent sign
   '#163'	=> qw({\pounds}),	# {\pounds}: pound sign
   '#164'	=> qw({\$}),	# {$}: general currency sign
   '#165'	=> qw({JPY}),	# {JPY}: yen sign
   '#166'	=> qw({|}),	# {|}: broken vertical line
   '#167'	=> qw({\S}),	# {\S}: section sign
   '#168'	=> qw(\"\  ),	# \"\ : diaeresis
   '#169'	=> qw({\copyright}),	# {\copyright}: copyright sign
   '#170'	=> qw({_a}),	# {_a}: ordinal indicator, feminine
   '#171'	=> qw({\guillemotleft}),	# {\guillemotleft}: left angle quotation mark
   '#172'	=> qw({\neg}),	# {\neg}: not sign
   '#173'	=> qw(\"-),	# \"-: soft hyphen
   '#174'	=> qw({\(R\)}),	# {(R)}: registered sign
   '#175'	=> qw({=}),	# {=}: macron
   '#176'	=> qw(^{\circ}),# ^{\circ}: superscript zero or degree sign
   '#177'	=> qw({\pm}),	# {\pm}: plus or minus sign
   '#178'	=> qw(^{2}),	# ^{2}: superscript two
   '#179'	=> qw(^{3}),	# ^{3}: superscript three
   '#180'	=> qw(\'\ ),	# \'\ : acute accent
   '#181'	=> qw({\mu}),	# {\mu}: micro sign
   '#182'	=> qw({\P}),	# {\P}: pilcrow
   '#183'	=> qw({\cdot}),# {\cdot}: middle dot
   '#184'	=> "\c{\ }",	# \c{\ }: cedilla
   '#185'	=> qw(^{1}),	# ^{1}: superscript one
   '#186'	=> qw({_o}),	# {_o}: ordinal indicator, masculine
   '#187'	=> qw({\guillemotright}),	# {\guillemotright}: right angle quotation mark
   '#188'	=> qw({1/4}),	# {1/4}: fraction one-quarter
   '#189'	=> qw({1/2}),	# {1/2}: fraction one-half
   '#190'	=> qw({3/4}),	# {3/4}: fraction three-quarters
   '#191'	=> qw({?`}),	# {?`}: inverted question mark
   '#192'	=> qw({\`A}),	# \`A: A with grave accent
   '#193'	=> qw({\'A}),	# \'A: A with acute accent
   '#194'	=> qw({\^A}),	# \^A: A with circumflex accent
   '#195'	=> qw({\~A}),	# \~A: A with tilde
   '#196'	=> qw({\"A}),	# \"A: A with diaeresis or umlaut mark
   '#197'	=> qw({\AA}),	# {\AA}: A with ring
   '#198'	=> qw({\AE}),	# {\AE}: AE diphthong
   '#199'	=> qw(\c{C}),	# \c{C}: C with cedilla
   '#200'	=> qw({\`E}),	# \`E: E with grave accent
   '#201'	=> qw({\'E}),	# \'E: E with acute accent
   '#202'	=> qw({\^E}),	# \^E: E with circumflex accent
   '#203'	=> qw({\"E}),	# \"E: E with diaeresis or umlaut mark
   '#204'	=> qw({\`I}),	# \`I: I with grave accent
   '#205'	=> qw({\'I}),	# \'I: I with acute accent
   '#206'	=> qw({\^I}),	# \^I: I with circumflex accent
   '#207'	=> qw({\"I}),	# \"I: I with diaeresis or umlaut mark
   '#208'	=> qw({-D}),	# {-D}: D with stroke, Icelandic eth
   '#209'	=> qw({\~N}),	# \~N: N with tilde
   '#210'	=> qw({\`O}),	# \`O: O with grave accent
   '#211'	=> qw({\'O}),	# \'O: O with acute accent
   '#212'	=> qw({\^O}),	# \^O: O with circumflex accent
   '#213'	=> qw({\~O}),	# \~O: O with tilde
   '#214'	=> qw({\"O}),	# \"O: O with diaeresis or umlaut mark
   '#215'	=> qw({\times}),	# {\times}: multiplication sign
   '#216'	=> qw({\O}),	# {\O}: O with slash
   '#217'	=> qw({\`U}),	# \`U: U with grave accent
   '#218'	=> qw({\'U}),	# \'U: U with acute accent
   '#219'	=> qw({\^U}),	# \^U: U with circumflex accent
   '#220'	=> qw({\"U}),	# \"U: U with diaeresis or umlaut mark
   '#221'	=> qw({\'Y}),	# \'Y: Y with acute accent
   '#222'	=> qw({\TH}),	# {\TH}: capital thorn, Icelandic
   '#223'	=> qw({\ss}),	# {\ss}: small sharp s, German
   '#224'	=> qw({\`a}),	# \`a: a with grave accent
   '#225'	=> qw({\'a}),	# \'a: a with acute accent
   '#226'	=> qw({\^a}),	# \^a: a with circumflex accent
   '#227'	=> qw({\~a}),	# \~a: a with tilde
   '#228'	=> qw({\"a}),	# \"a: a with diaeresis or umlaut mark
   '#229'	=> qw({\aa}),	# {\aa}: a with ring
   '#230'	=> qw({\ae}),	# {\ae}: ae diphthong
   '#231'	=> qw(\c{c}),	# \c{c}: c with cedilla
   '#232'	=> qw({\`e}),	# \`e: e with grave accent
   '#233'	=> qw({\'e}),	# \'e: e with acute accent
   '#234'	=> qw({\^e}),	# \^e: e with circumflex accent
   '#235'	=> qw({\"e}),	# \"e: e with diaeresis or umlaut mark
   '#236'	=> qw(\`{\i}),# \`{\i}: i with grave accent
   '#237'	=> qw(\'{\i}),# \'{\i}: i with acute accent
   '#238'	=> qw(\^{\i}),# \^{\i}: i with circumflex accent
   '#239'	=> qw(\"{\i}),# \"{\i}: i with diaeresis or umlaut mark
   '#240'	=> qw({\-d}),	# {-d}: d with stroke, Icelandic eth
   '#241'	=> qw({\~n}),	# \~n: n with tilde
   '#242'	=> qw({\`o}),	# \`o: o with grave accent
   '#243'	=> qw({\'o}),	# \'o: o with acute accent
   '#244'	=> qw({\^o}),	# \^o: o with circumflex accent
   '#245'	=> qw({\~o}),	# \~o: o with tilde
   '#246'	=> qw({\"o}),	# \"o: o with diaeresis or umlaut mark
   '#247'	=> qw({\div}),	# {\div}: division sign
   '#248'	=> qw({\o}),	# {\o}: o with slash
   '#249'	=> qw({\`u}),	# \`u: u with grave accent
   '#250'	=> qw({\'u}),	# \'u: u with acute accent
   '#251'	=> qw({\^u}),	# \^u: u with circumflex accent
   '#252'	=> qw({\"u}),	# \"u: u with diaeresis or umlaut mark
   '#253'	=> qw({\'y}),	# \'y: y with acute accent
   '#254'	=> qw({\th}),	# {\th}: small thorn, Icelandic
   '#255'	=> qw({\"y}),     # \"y: y with diaeresis or umlaut mark
   '#x0103'	=> qw(\u{a}), # LATIN SMALL LETTER A WITH BREVE
   '#x0102'	=> qw(\u{A}), # LATIN CAPITAL LETTER A WITH BREVE
   '#x0101'	=> qw({\=a}), # LATIN SMALL LETTER A WITH MACRON
   '#x0100'	=> qw({\=A}), # LATIN CAPITAL LETTER A WITH MACRON
   '#x0105'	=> qw({aogon}), # LATIN SMALL LETTER A WITH OGONEK
   '#x0104'	=> qw({Aogon}), # LATIN CAPITAL LETTER A WITH OGONEK
   '#x0107'	=> qw({\'c}), # LATIN SMALL LETTER C WITH ACUTE
   '#x0106'	=> qw({\'C}), # LATIN CAPITAL LETTER C WITH ACUTE
   '#x010D'	=> qw(\v{c}), # LATIN SMALL LETTER C WITH CARON
   '#x010C'	=> qw(\v{C}), # LATIN CAPITAL LETTER C WITH CARON
   '#x0109'	=> qw({\^c}), # LATIN SMALL LETTER C WITH CIRCUMFLEX
   '#x0108'	=> qw({\^C}), # LATIN CAPITAL LETTER C WITH CIRCUMFLEX
   '#x010B'	=> qw({\.c}), # DOT OPERATOR
   '#x010A'	=> qw({\.C}), # LATIN CAPITAL LETTER C WITH DOT ABOVE
   '#x010F'	=> qw(\v{d}), # LATIN SMALL LETTER D WITH CARON
   '#x010E'	=> qw(\v{D}), # LATIN CAPITAL LETTER D WITH CARON
   '#x0111'	=> qw({dstrok}), # LATIN SMALL LETTER D WITH STROKE
   '#x0110'	=> qw({Dstrok}), # LATIN CAPITAL LETTER D WITH STROKE
   '#x011B'	=> qw(\v{e}), # LATIN SMALL LETTER E WITH CARON
   '#x011A'	=> qw(\v{E}), # LATIN CAPITAL LETTER E WITH CARON
   '#x0117'	=> qw({\.e}), # LATIN SMALL LETTER E WITH DOT ABOVE
   '#x0116'	=> qw({\.E}), # LATIN CAPITAL LETTER E WITH DOT ABOVE
   '#x0113'	=> qw({\=e}), # LATIN SMALL LETTER E WITH MACRON
   '#x0112'	=> qw({\=E}), # LATIN CAPITAL LETTER E WITH MACRON
   '#x0119'	=> qw({eogon}), # LATIN SMALL LETTER E WITH OGONEK
   '#x0118'	=> qw({Eogon}), # LATIN CAPITAL LETTER E WITH OGONEK
   '#x01F5'	=> qw({\'g}), # LATIN SMALL LETTER G WITH ACUTE
   '#x011F'	=> qw(\u{g}), # LATIN SMALL LETTER G WITH BREVE
   '#x011E'	=> qw(\u{G}), # LATIN CAPITAL LETTER G WITH BREVE
   '#x0122'	=> qw(\c{G}), # LATIN CAPITAL LETTER G WITH CEDILLA
   '#x011D'	=> qw({\^g}), # LATIN SMALL LETTER G WITH CIRCUMFLEX
   '#x011C'	=> qw({\^G}), # LATIN CAPITAL LETTER G WITH CIRCUMFLEX
   '#x0121'	=> qw({\.g}), # LATIN SMALL LETTER G WITH DOT ABOVE
   '#x0120'	=> qw({\.G}), # LATIN CAPITAL LETTER G WITH DOT ABOVE
   '#x0125'	=> qw({\^h}), # LATIN SMALL LETTER H WITH CIRCUMFLEX
   '#x0124'	=> qw({\^H}), # LATIN CAPITAL LETTER H WITH CIRCUMFLEX
   '#x0127'	=> qw({hstrok}), # LATIN SMALL LETTER H WITH STROKE
   '#x0126'	=> qw({Hstrok}), # LATIN CAPITAL LETTER H WITH STROKE
   '#x0130'	=> qw({\.I}), # LATIN CAPITAL LETTER I WITH DOT ABOVE
   '#x012A'	=> qw({\=I}), # LATIN CAPITAL LETTER I WITH MACRON
   '#x012B'	=> qw({\=i}), # LATIN SMALL LETTER I WITH MACRON
   '#x0133'	=> qw({\ijlig}), # LATIN SMALL LIGATURE IJ
   '#x0132'	=> qw({\IJlig}), # LATIN CAPITAL LIGATURE IJ
   '#x0131'	=> qw({\i}), # LATIN SMALL LETTER DOTLESS I
   '#x012F'	=> qw({iogon}), # LATIN SMALL LETTER I WITH OGONEK
   '#x012E'	=> qw({Iogon}), # LATIN CAPITAL LETTER I WITH OGONEK
   '#x0129'	=> qw({\~{\i}}), # LATIN SMALL LETTER I WITH TILDE
   '#x0128'	=> qw({\~I}), # LATIN CAPITAL LETTER I WITH TILDE
   '#x0135'	=> qw({\^{\j}}), # LATIN SMALL LETTER J WITH CIRCUMFLEX
   '#x0134'	=> qw({\^J}), # LATIN CAPITAL LETTER J WITH CIRCUMFLEX
   '#x0137'	=> qw(\c{k}), # LATIN SMALL LETTER K WITH CEDILLA
   '#x0136'	=> qw(\c{K}), # LATIN CAPITAL LETTER K WITH CEDILLA
   '#x0138'	=> qw({kgreen}), # LATIN SMALL LETTER KRA
   '#x013A'	=> qw({\'l}), # LATIN SMALL LETTER L WITH ACUTE
   '#x0139'	=> qw({\'L}), # LATIN CAPITAL LETTER L WITH ACUTE
   '#x013E'	=> qw(\v{l}), # LATIN SMALL LETTER L WITH CARON
   '#x013D'	=> qw(\v{L}), # LATIN CAPITAL LETTER L WITH CARON
   '#x013C'	=> qw(\c{l}), # LATIN SMALL LETTER L WITH CEDILLA
   '#x013B'	=> qw(\c{L}), # LATIN CAPITAL LETTER L WITH CEDILLA
   '#x0140'	=> qw({lmidot}), # LATIN SMALL LETTER L WITH MIDDLE DOT
   '#x013F'	=> qw({Lmidot}), # LATIN CAPITAL LETTER L WITH MIDDLE DOT
   '#x0142'	=> qw({lstrok}), # LATIN SMALL LETTER L WITH STROKE
   '#x0141'	=> qw({Lstrok}), # LATIN CAPITAL LETTER L WITH STROKE
   '#x0144'	=> qw({\'n}), # LATIN SMALL LETTER N WITH ACUTE
   '#x0143'	=> qw({\'N}), # LATIN CAPITAL LETTER N WITH ACUTE
   '#x014B'	=> qw({eng}), # LATIN SMALL LETTER ENG
   '#x014A'	=> qw({ENG}), # LATIN CAPITAL LETTER ENG
   '#x0149'	=> qw({'n}), # LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
   '#x0148'	=> qw(\v{n}), # LATIN SMALL LETTER N WITH CARON
   '#x0147'	=> qw(\v{N}), # LATIN CAPITAL LETTER N WITH CARON
   '#x0146'	=> qw(\c{n}), # LATIN SMALL LETTER N WITH CEDILLA
   '#x0145'	=> qw(\c{N}), # LATIN CAPITAL LETTER N WITH CEDILLA
   '#x0151'	=> qw(\H{o}), # LATIN SMALL LETTER O WITH DOUBLE ACUTE
   '#x0150'	=> qw(\H{O}), # LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
   '#x014C'	=> qw({\=O}), # LATIN CAPITAL LETTER O WITH MACRON
   '#x014D'	=> qw({\=o}), # LATIN SMALL LETTER O WITH MACRON
   '#x0153'	=> qw({\oe}), # LATIN SMALL LIGATURE OE
   '#x0152'	=> qw({\OE}), # LATIN CAPITAL LIGATURE OE
   '#x0155'	=> qw({\'r}), # LATIN SMALL LETTER R WITH ACUTE
   '#x0154'	=> qw({\'R}), # LATIN CAPITAL LETTER R WITH ACUTE
   '#x0159'	=> qw(\v{r}), # LATIN SMALL LETTER R WITH CARON
   '#x0158'	=> qw(\v{R}), # LATIN CAPITAL LETTER R WITH CARON
   '#x0157'	=> qw(\c{r}), # LATIN SMALL LETTER R WITH CEDILLA
   '#x0156'	=> qw(\c{R}), # LATIN CAPITAL LETTER R WITH CEDILLA
   '#x015B'	=> qw({\'s}), # LATIN SMALL LETTER S WITH ACUTE
   '#x015A'	=> qw({\'S}), # LATIN CAPITAL LETTER S WITH ACUTE
   '#x0161'	=> qw(\v{s}), # LATIN SMALL LETTER S WITH CARON
   '#x0160'	=> qw(\v{S}), # LATIN CAPITAL LETTER S WITH CARON
   '#x015F'	=> qw(\c{s}), # LATIN SMALL LETTER S WITH CEDILLA
   '#x015E'	=> qw(\c{S}), # LATIN CAPITAL LETTER S WITH CEDILLA
   '#x015D'	=> qw({\^s}), # LATIN SMALL LETTER S WITH CIRCUMFLEX
   '#x015C'	=> qw({\^S}), # LATIN CAPITAL LETTER S WITH CIRCUMFLEX
   '#x0165'	=> qw(\v{t}), # LATIN SMALL LETTER T WITH CARON
   '#x0164'	=> qw(\v{T}), # LATIN CAPITAL LETTER T WITH CARON
   '#x0163'	=> qw(\c{t}), # LATIN SMALL LETTER T WITH CEDILLA
   '#x0162'	=> qw(\c{T}), # LATIN CAPITAL LETTER T WITH CEDILLA
   '#x0167'	=> qw({tstrok}), # LATIN SMALL LETTER T WITH STROKE
   '#x0166'	=> qw({Tstrok}), # LATIN CAPITAL LETTER T WITH STROKE
   '#x016D'	=> qw(\u{u}), # LATIN SMALL LETTER U WITH BREVE
   '#x016C'	=> qw(\u{U}), # LATIN CAPITAL LETTER U WITH BREVE
   '#x0171'	=> qw(\H{u}), # LATIN SMALL LETTER U WITH DOUBLE ACUTE
   '#x0170'	=> qw(\H{U}), # LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
   '#x016B'	=> qw({\=u}), # LATIN SMALL LETTER U WITH MACRON
   '#x016A'	=> qw({\=U}), # LATIN CAPITAL LETTER U WITH MACRON
   '#x0173'	=> qw({uogon}), # LATIN SMALL LETTER U WITH OGONEK
   '#x0172'	=> qw({Uogon}), # LATIN CAPITAL LETTER U WITH OGONEK
   '#x016F'	=> qw({uring}), # LATIN SMALL LETTER U WITH RING ABOVE
   '#x016E'	=> qw({Uring}), # LATIN CAPITAL LETTER U WITH RING ABOVE
   '#x0169'	=> qw({\~u}), # LATIN SMALL LETTER U WITH TILDE
   '#x0168'	=> qw({\~U}), # LATIN CAPITAL LETTER U WITH TILDE
   '#x0175'	=> qw({\^w}), # LATIN SMALL LETTER W WITH CIRCUMFLEX
   '#x0174'	=> qw({\^W}), # LATIN CAPITAL LETTER W WITH CIRCUMFLEX
   '#x0177'	=> qw({\^y}), # LATIN SMALL LETTER Y WITH CIRCUMFLEX
   '#x0176'	=> qw({\^Y}), # LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
   '#x0178'	=> qw({\"Y}), # LATIN CAPITAL LETTER Y WITH DIAERESIS
   '#x017A'	=> qw({\'z}), # LATIN SMALL LETTER Z WITH ACUTE
   '#x0179'	=> qw({\'Z}), # LATIN CAPITAL LETTER Z WITH ACUTE
   '#x017E'	=> qw(\v{z}), # LATIN SMALL LETTER Z WITH CARON
   '#x017D'	=> qw(\v{Z}), # LATIN CAPITAL LETTER Z WITH CARON
   '#x017C'	=> qw({\.z}), # LATIN SMALL LETTER Z WITH DOT ABOVE
   '#x017B'	=> qw({\.Z}), # LATIN CAPITAL LETTER Z WITH DOT ABOVE
   '#268'=> qw(\v{C}),
   '#269'=> qw(\v{c}),
   '#328'=> qw(\v{n})
		    );


  %html_text_table = (
   'amp'	=> '&',
   'lt'		=> '<',
   'gt'		=> qw(>),
#   'nbsp'	=> qw( ),	# {~}: NBSP no-break space:
   'Agrave'	=> qw(),	# \`A: A with grave accent
   'Aacute'	=> qw(),	# \'A: A with acute accent
   'Acirc'	=> qw(),	# \^A: A with circumflex accent
   'Atilde'	=> qw(),	# \~A: A with tilde
   'Auml'	=> qw(),	# \"A: A with diaeresis or umlaut mark
   'Aring'	=> qw(AA),	# {\AA}: A with ring
   'AElig'	=> qw(AE),	# {\AE}: AE diphthong
   'Ccedil'	=> qw(),	# \c{C}: C with cedilla
   'Egrave'	=> qw(),	# \`E: E with grave accent
   'Eacute'	=> qw(),	# \'E: E with acute accent
   'Ecirc'	=> qw(),	# \^E: E with circumflex accent
   'Euml'	=> qw(),	# \"E: E with diaeresis or umlaut mark
   'Igrave'	=> qw(),	# \`I: I with grave accent
   'Iacute'	=> qw(),	# \'I: I with acute accent
   'Icirc'	=> qw(),	# \^I: I with circumflex accent
   'Iuml'	=> qw(),	# \"I: I with diaeresis or umlaut mark
   'ETH'	=> qw(D),	# {-D}: D with stroke, Icelandic eth
   'Ntilde'	=> qw(),	# \~N: N with tilde
   'Ograve'	=> qw(),	# \`O: O with grave accent
   'Oacute'	=> qw(),	# \'O: O with acute accent
   'Ocirc'	=> qw(),	# \^O: O with circumflex accent
   'Otilde'	=> qw(),	# \~O: O with tilde
   'Ouml'	=> qw(),	# \"O: O with diaeresis or umlaut mark
   'Oslash'	=> qw(),	# {\O}: O with slash
   'Ugrave'	=> qw(),	# \`U: U with grave accent
   'Uacute'	=> qw(),	# \'U: U with acute accent
   'Ucirc'	=> qw(),	# \^U: U with circumflex accent
   'Uuml'	=> qw(),	# \"U: U with diaeresis or umlaut mark
   'Yacute'	=> qw(),	# \'Y: Y with acute accent
   'THORN'	=> qw(TH),	# {\TH}: capital thorn, Icelandic
   'szlig'	=> qw(),	# {\ss}: small sharp s, German
   'agrave'	=> qw(),	# \`a: a with grave accent
   'aacute'	=> qw(),	# \'a: a with acute accent
   'acirc'	=> qw(),	# \^a: a with circumflex accent
   'atilde'	=> qw(),	# \~a: a with tilde
   'auml'	=> qw(),	# \"a: a with diaeresis or umlaut mark
   'aring'	=> qw(aa),	# {\aa}: a with ring
   'aelig'	=> qw(ae),	# {\ae}: ae diphthong
   'ccedil'	=> qw(),	# \c{c}: c with cedilla
   'egrave'	=> qw(),	# \`e: e with grave accent
   'eacute'	=> qw(),	# \'e: e with acute accent
   'ecirc'	=> qw(),	# \^e: e with circumflex accent
   'euml'	=> qw(),	# \"e: e with diaeresis or umlaut mark
   'igrave'	=> qw(),# \`{\i}: i with grave accent
   'iacute'	=> qw(),# \'{\i}: i with acute accent
   'icirc'	=> qw(),# \^{\i}: i with circumflex accent
   'iuml'	=> qw(),# \"{\i}: i with diaeresis or umlaut mark
   'eth'	=> qw(d),	# {-d}: d with stroke, Icelandic eth
   'ntilde'	=> qw(),	# \~n: n with tilde
   'ograve'	=> qw(),	# \`o: o with grave accent
   'oacute'	=> qw(),	# \'o: o with acute accent
   'ocirc'	=> qw(),	# \^o: o with circumflex accent
   'otilde'	=> qw(),	# \~o: o with tilde
   'ouml'	=> qw(),	# \"o: o with diaeresis or umlaut mark
   'oslash'	=> qw(),	# {\o}: o with slash
   'ugrave'	=> qw(),	# \`u: u with grave accent
   'uacute'	=> qw(),	# \'u: u with acute accent
   'ucirc'	=> qw(),	# \^u: u with circumflex accent
   'uuml'	=> qw(),	# \"u: u with diaeresis or umlaut mark
   'yacute'	=> qw(),	# \'y: y with acute accent
   'thorn'	=> qw(th),	# {\th}: small thorn, Icelandic
   'yuml'	=> qw(),	# \"y: y with diaeresis or umlaut mark
   '#192'	=> qw(),	# \`A: A with grave accent
   '#193'	=> qw(),	# \'A: A with acute accent
   '#194'	=> qw(),	# \^A: A with circumflex accent
   '#195'	=> qw(),	# \~A: A with tilde
   '#196'	=> qw(),	# \"A: A with diaeresis or umlaut mark
   '#197'	=> qw(AA),	# {\AA}: A with ring
   '#198'	=> qw(AE),	# {\AE}: AE diphthong
   '#199'	=> qw(),	# \c{C}: C with cedilla
   '#200'	=> qw(),	# \`E: E with grave accent
   '#201'	=> qw(),	# \'E: E with acute accent
   '#202'	=> qw(),	# \^E: E with circumflex accent
   '#203'	=> qw(),	# \"E: E with diaeresis or umlaut mark
   '#204'	=> qw(),	# \`I: I with grave accent
   '#205'	=> qw(),	# \'I: I with acute accent
   '#206'	=> qw(),	# \^I: I with circumflex accent
   '#207'	=> qw(),	# \"I: I with diaeresis or umlaut mark
   '#208'	=> qw(D),	# {-D}: D with stroke, Icelandic eth
   '#209'	=> qw(),	# \~N: N with tilde
   '#210'	=> qw(),	# \`O: O with grave accent
   '#211'	=> qw(),	# \'O: O with acute accent
   '#212'	=> qw(),	# \^O: O with circumflex accent
   '#213'	=> qw(),	# \~O: O with tilde
   '#214'	=> qw(),	# \"O: O with diaeresis or umlaut mark
   '#216'	=> qw(),	# {\O}: O with slash
   '#217'	=> qw(),	# \`U: U with grave accent
   '#218'	=> qw(),	# \'U: U with acute accent
   '#219'	=> qw(),	# \^U: U with circumflex accent
   '#220'	=> qw(),	# \"U: U with diaeresis or umlaut mark
   '#221'	=> qw(),	# \'Y: Y with acute accent
   '#222'	=> qw(TH),	# {\TH}: capital thorn, Icelandic
   '#223'	=> qw(),	# {\ss}: small sharp s, German
   '#224'	=> qw(),	# \`a: a with grave accent
   '#225'	=> qw(),	# \'a: a with acute accent
   '#226'	=> qw(),	# \^a: a with circumflex accent
   '#227'	=> qw(),	# \~a: a with tilde
   '#228'	=> qw(),	# \"a: a with diaeresis or umlaut mark
   '#229'	=> qw(aa),	# {\aa}: a with ring
   '#230'	=> qw(ae),	# {\ae}: ae diphthong
   '#231'	=> qw(),	# \c{c}: c with cedilla
   '#232'	=> qw(),	# \`e: e with grave accent
   '#233'	=> qw(),	# \'e: e with acute accent
   '#234'	=> qw(),	# \^e: e with circumflex accent
   '#235'	=> qw(),	# \"e: e with diaeresis or umlaut mark
   '#236'	=> qw(),# \`{\i}: i with grave accent
   '#237'	=> qw(),# \'{\i}: i with acute accent
   '#238'	=> qw(),# \^{\i}: i with circumflex accent
   '#239'	=> qw(),# \"{\i}: i with diaeresis or umlaut mark
   '#240'	=> qw(-d),	# {-d}: d with stroke, Icelandic eth
   '#241'	=> qw(n~),	# \~n: n with tilde
   '#242'	=> qw(),	# \`o: o with grave accent
   '#243'	=> qw(),	# \'o: o with acute accent
   '#244'	=> qw(),	# \^o: o with circumflex accent
   '#245'	=> qw(),	# \~o: o with tilde
   '#246'	=> qw(),	# \"o: o with diaeresis or umlaut mark
   '#248'	=> qw(),	# {\o}: o with slash
   '#249'	=> qw(),	# \`u: u with grave accent
   '#250'	=> qw(),	# \'u: u with acute accent
   '#251'	=> qw(),	# \^u: u with circumflex accent
   '#252'	=> qw(),	# \"u: u with diaeresis or umlaut mark
   '#253'	=> qw(),	# \'y: y with acute accent
   '#254'	=> qw(th),	# {\th}: small thorn, Icelandic
   '#255'	=> qw(),     # \"y: y with diaeresis or umlaut mark
   '#328'=> qw(n)
		    );

sub html_to_TeX {
  # in string (first arg) translate html to TeX, return translated string
  my $text = shift;
  # If no translation is found in the table, we hope that exactly the same
  # name as the html entity is given to the TeX macro. Works at least for simple
  # things as Omega and alike. For others we have to complete the table occasionaly.
  # To work well in TeX expression that contain mathematical symbols should always be
  # enclosed in math tags.
  $text =~ s/&tab;/ & /g ;
  $text =~ s/\&([^\;&]+)\;/$html_TeX_table{$1} || qw(\\).$1." "/ge;
  return $text;
};


# Translate some other additional html tags to TeX.
# Beware that we don't match recursively so only very
# simple expressions such as <math>A<sub>i,j</sub><math> 
# are handled. 
# The tag ``span'' can be used to protect characters from being
# transformed by bibtex. E.g you could write 
# <span>N</span><span>P</span>-complete
# to ensure that the NP is always capitalized.
sub span2group {
  $str = shift;
  $str =~ s|{|\\{|g;
  $str =~ s|}|\\}|g;
  $str = html_to_TeX(
		     $str
		    );
  #print STDERR "now $str\n";
  #$str =~ s/<(span|div)[ 	\n]+class=[\\\"]([a-z]+)[\\\"]>/<$2>/g;
  $str =~ s!<(span|div)([ 	\n]+[^>]+)?>!{!g;
  $str =~ s|<br([ 	\n]+[^>]+)?/?>|\\par |g;
  $str =~ s!<(textrm|textsc|pmod|mathcal)([ 	\n]+[^>]+)?>!\\$1\{!g;
  $str =~ s!<binom>([^,]+),!\\binom\{$1\}\{!g;
  $str =~ s!</binom>!\}!g;
  $str =~ s|<mathop([ 	\n]+[^>]+)?>|\\textrm{|g;
  $str =~ s|<mathbb([ 	\n]+[^>]+)?>|\\mathbb{|g;
  $str =~ s|<mathbf([ 	\n]+[^>]+)?>|{\\mathbf |g;
  $str =~ s|<i([ 	\n]+[^>]+)?>|\\textit{|g;
  $str =~ s|<b([ 	\n]+[^>]+)?>|\\textbf{|g;
  $str =~ s|<em([ 	\n]+[^>]+)?>|\\emph{|g;
  $str =~ s|<math([ 	\n]+[^>]+)?>|{\${|g;
  $str =~ s!<(displaymath|cases)([ 	\n]+[^>]+)?>!\\begin{$1}!g;
  $str =~ s|<overline([ 	\n]+[^>]+)?>|\\overline{|g;
  $str =~ s|<sqrt([ 	\n]+[^>]+)?>|\\sqrt{|g;
  $str =~ s|</sqrt([ 	\n]+[^>]+)?>|}|g;
  $str =~ s|<p([ 	\n]+[^>]+)?>|{|g;
  $str =~ s|</p([ 	\n]+[^>]+)?>|\\par}|g;
  $str =~ s|<ol([ 	\n]+[^>]+)?>|\\begin{enumerate}|g;
  $str =~ s|</ol([ 	\n]+[^>]+)?>|\\end{enumerate}|g;
  $str =~ s|<ul([ 	\n]+[^>]+)?>|\\begin{itemize}|g;
  $str =~ s|</ul([ 	\n]+[^>]+)?>|\\end{itemize}|g;
  $str =~ s|<li([ 	\n]+[^>]+)?>|\\item{}|g;
  $str =~ s|</li([ 	\n]+[^>]+)?>||g;
  $str =~ s|<sub([ 	\n]+[^>]+)?>|_{|g;
  $str =~ s|<sup([ 	\n]+[^>]+)?>|^{|g;
  $str =~ s!</(span|div)([ 	\n]+[^>]+)?>!}!g;
  $str =~ s|</i([ 	\n]+[^>]+)?>|}|g;
  $str =~ s!</(textrm|textsc|pmod|mathcal)([ 	\n]+[^>]+)?>!}!g;
  $str =~ s|</mathbb([ 	\n]+[^>]+)?>|}|g;
  $str =~ s|</mathbf([ 	\n]+[^>]+)?>|}|g;
  $str =~ s|</mathop([ 	\n]+[^>]+)?>|}|g;
  $str =~ s|</b([ 	\n]+[^>]+)?>|}|g;
  $str =~ s|</em([ 	\n]+[^>]+)?>|}|g;
  $str =~ s|</overline([ 	\n]+[^>]+)?>|}|g;
  $str =~ s|</math([ 	\n]+[^>]+)?>|}\$}|g;
  $str =~ s!</(displaymath|cases)([ 	\n]+[^>]+)?>!\\end{$1}!g;
  $str =~ s|</sub([ 	\n]+[^>]+)?>|}|g;
  $str =~ s|</sup([ 	\n]+[^>]+)?>|}|g;
  return $str;
  }




sub html_to_text {
# in string (first arg) translate html to text, return translated string
  my($text)=@_;

  $text =~ s/\&([^\;]+)\;/$html_text_table{$1} || $MATCH/ge;
  return $text;
};

sub http_replace {
  my $arg = shift;
  return sprintf("%%%2X",ord($arg));
}

sub http_protect {
  my $str = $_[0];
  $str =~ s!([<>&"'%])!&http_replace("$1")!ge ;
  return $str;
}




my %mathbb;
$mathbb{   "A" } =  "E4AF"; # open face letter A
$mathbb{   "B" } =  "E4B0"; # open face letter B
$mathbb{   "C" } =  "2102"; # open face letter C
$mathbb{   "D" } =  "E4B1"; # open face letter D
$mathbb{   "E" } =  "E4B2"; # open face letter E
$mathbb{   "F" } =  "E4B3"; # open face letter F
$mathbb{   "G" } =  "E4B4"; # open face letter G
$mathbb{   "H" } =  "E4B5"; # open face letter H
$mathbb{   "I" } =  "E4B6"; # open face letter I
$mathbb{   "J" } =  "E4B7"; # open face letter J
$mathbb{   "K" } =  "E4B8"; # open face letter K
$mathbb{   "L" } =  "E4B9"; # open face letter L
$mathbb{   "M" } =  "E4BA"; # open face letter M
$mathbb{   "N" } =  "E4BB"; # open face letter N
$mathbb{   "O" } =  "E4BC"; # open face letter O
$mathbb{   "P" } =  "2119"; # open face letter P
$mathbb{   "Q" } =  "211A"; # open face letter Q
$mathbb{   "R" } =  "211D"; # open face letter R
$mathbb{   "S" } =  "E4BD"; # open face letter S
$mathbb{   "T" } =  "E4BE"; # open face letter T
$mathbb{   "U" } =  "E4BF"; # open face letter U
$mathbb{   "V" } =  "E4C0"; # open face letter V
$mathbb{   "W" } =  "E4C1"; # open face letter W
$mathbb{   "X" } =  "E4C2"; # open face letter X
$mathbb{   "Y" } =  "E4C3"; # open face letter Y
$mathbb{   "Z" } =  "E4C4"; # open face letter Z


sub mathbb {
  my $arg = shift;
  print STDERR "mathbb asked for |$arg| -> $mathbb{$arg}\n";
  return "&#x".$mathbb{"$arg"}.";";
}



sub abs_to_html {
  my $ARG = shift;

  $ARG =~ s!<math>!<div class="math">!g;
  $ARG =~ s!</math>!</div>!g;
  $ARG =~ s!<displaymath>!<div class="displaymath">!g;
  $ARG =~ s!</displaymath>!</div>!g;
  $ARG =~ s!<sqrt>!&#8730;<overline>!g;
  $ARG =~ s!</sqrt>!</overline>!g;
  $ARG =~ s!<(overline|bar)>!<div class="overline">!g;
  $ARG =~ s!</(overline|bar)>!</div>!g;
  $ARG =~ s!<mathbb>([A-Z])</mathbb>!&mathbb("$1")!ge;
  $ARG =~ s!<mathcal>!<div  class="mathcal">!g;
  $ARG =~ s!</mathcal>!</div>!g;
  $ARG =~ s!<binom>!<mathop>binom</mathop>(!g;
  $ARG =~ s!</binom>!)!g;
  $ARG =~ s!<mathop>!<div  class="mathop">!g;
  $ARG =~ s!</mathop>!</div>!g;
  $ARG =~ s!<textsc>!<div  class="small-caps">!g;
  $ARG =~ s!</textsc>!</div>!g;
  $ARG =~ s!<sup>!<div  class="sup">!g;
  $ARG =~ s!</sup>!</div>!g;
  $ARG =~ s!<sub>!<div  class="sub">!g;
  $ARG =~ s!</sub>!</div>!g;
  $ARG =~ s!<cases>!<div  class="group">[begin cases]<br />!g;
  $ARG =~ s!</cases>!<br />[end cases]</div>!g;
  $ARG =~ s!<pmod>!&nbsp;(!g;
  $ARG =~ s!</pmod>!)!g;
  $ARG =~ s!&(tab);!&nbsp;!g;
  $ARG =~ s!&(cr);!<br />!g;
  $ARG =~ s!&(min|max|log|lim|sup|limsup|inf|gcd|sin|cos|sinh|cosh|log|ln);!<div class="mathop">$1</div>!g;

  return $ARG;
}

sub read_plain {
  my $plain = shift;
  chomp($plain);
  my $raw = shift;

  my %fields;
  my $field=();
  my $conte;

  open(IN, "<", "$plain") or die "could not open abstract file $plain:$!\n";

  use Encode;
  while (<IN>) {
    s/
//g;
    $_ = decode ('iso_8859_1', $_);
    if ($field) {
      if ( /^[ \t]*$/ ) {
	$field=();
      } else {
	$ARG = abs_to_html("$ARG")
	  if (!defined($raw));
	$fields{$field} = $fields{$field}." $ARG";
      }
      ;
    } else {
      ($field,$conte) = m/([-a-z.]+): *(.+)/i;
      if (defined($field)) {
	$field = lc($field);
	if (defined($conte)) {
	  $conte = abs_to_html("$conte")
	    if (!defined($raw));
	  $fields{$field} = "$conte";
	} else {
	  $fields{$field} = ""; 
	}
      }
    }
  }
  foreach my $key (keys %fields) {
    chomp $fields{"$key"};
  }
  return %fields;
}

sub author_list {
  my $arg = shift;
  $arg =~ s/ {1,}$//;
  $arg =~ s!</?div[^>]*>!!g;
  $arg =~ s/\&nbsp\;$//;
  my @author = ();
  my @auth = split /[ ]{1,}and[ ]{1,}/, $arg;


  foreach my $auth (@auth) {
    my @aut = split /[ ]*,[ ]*/, $auth;
    # Try to find out if this was already prepared to fit into the
    # bibtex scheme `last name, first name, supplement' This can only
    # be a heuristic. In particular we can't decide whether something
    # like `Heroic Author, Anne Pierre' reffers to one or two
    # authors. Since last names with blanks in seem to be rare, we
    # arbitraryly decide that this corresponds to two.
    if ($#aut == 1 || $#aut == 2) {
       my $susp = 0;
       foreach my $part (@aut) {
	 #print STDERR "|$part|\n";
	 $part =~ s/^ {1,}// ;
	 $part =~ s/ {1,}$// ;
	 $susp = 1
	   if (!($part =~ m/ /));
	 $susp = 1
	   if ($part =~ m/ [a-zA-Z]\.$/);
       }
       if ($susp) {
	 print STDERR "`$auth' looks like valid bibtex name\n";
	 @aut = ($auth);
       }
    }
    @author = (@author, @aut);
  }
  return @author;
}


# while (defined ($line=<STDIN>)) {
# $line = span2group($line);
# print $line;
# };
